# prompt-actions [![NPM version](https://img.shields.io/npm/v/prompt-actions.svg?style=flat)](https://www.npmjs.com/package/prompt-actions) [![NPM monthly downloads](https://img.shields.io/npm/dm/prompt-actions.svg?style=flat)](https://npmjs.org/package/prompt-actions) [![NPM total downloads](https://img.shields.io/npm/dt/prompt-actions.svg?style=flat)](https://npmjs.org/package/prompt-actions) [![Linux Build Status](https://img.shields.io/travis/enquirer/prompt-actions.svg?style=flat&label=Travis)](https://travis-ci.org/enquirer/prompt-actions)

> Action manager for prompt-base.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save prompt-actions
```

<details>
<summary><strong>What does this do?</strong></summary>

Used by [prompt-base](https://github.com/enquirer/prompt-base) for toggling choices and updating the pointer position on prompts.

This is a separate module so that it is easier to maintain and unit test, and so that it can also be used by custom prompts when needed.

</details>

## Usage

Add this library to your custom [prompt][base-prompt] with the following line of code:

```js
var Actions = require('prompt-actions');
```

## About

### Related projects

* [enquirer](https://www.npmjs.com/package/enquirer): Intuitive, plugin-based prompt system for node.js. | [homepage](http://enquirer.io "Intuitive, plugin-based prompt system for node.js.")
* [prompt-base](https://www.npmjs.com/package/prompt-base): Base prompt module used for creating custom prompts. | [homepage](https://github.com/enquirer/prompt-base "Base prompt module used for creating custom prompts.")
* [prompt-choices](https://www.npmjs.com/package/prompt-choices): Create an array of multiple choice objects for use in prompts. | [homepage](https://github.com/enquirer/prompt-choices "Create an array of multiple choice objects for use in prompts.")
* [prompt-grid](https://www.npmjs.com/package/prompt-grid): Prompt that allows the user to re-arrange the cells in a grid in the terminal. | [homepage](https://github.com/enquirer/prompt-grid "Prompt that allows the user to re-arrange the cells in a grid in the terminal.")
* [prompt-sort](https://www.npmjs.com/package/prompt-sort): Prompt that allows the user to re-order items in a list of choices. | [homepage](https://github.com/enquirer/prompt-sort "Prompt that allows the user to re-order items in a list of choices.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on June 02, 2017._